<?php
/**
 * TuxoPay Blocks Support
 */

use Automattic\WooCommerce\Blocks\Payments\Integrations\AbstractPaymentMethodType;

defined('ABSPATH') || exit;

final class WC_Gateway_TuxoPay_Blocks_Support extends AbstractPaymentMethodType {

    /**
     * Payment method name
     */
    protected $name = 'tuxopay';

    /**
     * Gateway instance
     */
    private $gateway;

    /**
     * Initialize the payment method
     */
    public function initialize() {
        $this->settings = get_option('woocommerce_tuxopay_settings', array());
        $gateways = WC()->payment_gateways->payment_gateways();
        $this->gateway = isset($gateways['tuxopay']) ? $gateways['tuxopay'] : null;
    }

    /**
     * Check if payment method is active
     */
    public function is_active() {
        return $this->gateway && $this->gateway->is_available();
    }

    /**
     * Register scripts
     */
    public function get_payment_method_script_handles() {
        $script_path = '/build/index.js';
        $script_url = TUXOPAY_ORCHESTRATOR_PLUGIN_URL . 'build/index.js';

        $script_asset_path = TUXOPAY_ORCHESTRATOR_PLUGIN_DIR . 'build/index.asset.php';
        $script_asset = file_exists($script_asset_path)
            ? require $script_asset_path
            : array(
                'dependencies' => array(),
                'version' => TUXOPAY_ORCHESTRATOR_VERSION,
            );

        wp_register_script(
            'wc-tuxopay-blocks-integration',
            $script_url,
            $script_asset['dependencies'],
            $script_asset['version'],
            true
        );

        return array('wc-tuxopay-blocks-integration');
    }

    /**
     * Get payment method data
     */
    public function get_payment_method_data() {
        return array(
            'title' => $this->gateway ? $this->gateway->title : '',
            'description' => $this->gateway ? $this->gateway->description : '',
            'supports' => array_filter($this->gateway ? $this->gateway->supports : array(), array($this->gateway, 'supports')),
        );
    }
}
