import { registerPaymentMethod } from '@woocommerce/blocks-registry';
import { decodeEntities } from '@wordpress/html-entities';
import { getSetting } from '@woocommerce/settings';

const settings = getSetting('tuxopay_data', {});

const defaultLabel = decodeEntities(settings.title) || 'TuxoPay';
const defaultDescription = decodeEntities(settings.description) || '';

const Content = () => {
    return defaultDescription ? <div>{decodeEntities(defaultDescription)}</div> : null;
};

const Label = () => {
    return <span>{defaultLabel}</span>;
};

registerPaymentMethod({
    name: 'tuxopay',
    label: <Label />,
    content: <Content />,
    edit: <Content />,
    canMakePayment: () => true,
    ariaLabel: defaultLabel,
    supports: {
        features: settings.supports || [],
    },
});
