<?php
/**
 * Plugin Name: TuxoPay Orchestrator for WooCommerce
 * Plugin URI: https://orchestrator.tuxopay.com
 * Description: Accept payments via TuxoPay Orchestrator payment gateway
 * Version: 1.0.0
 * Author: TuxoPay
 * Author URI: https://tuxopay.com
 * Text Domain: tuxopay-orchestrator
 * Requires at least: 5.8
 * Requires PHP: 7.4
 * WC requires at least: 6.0
 * WC tested up to: 9.0
 */

defined('ABSPATH') || exit;

define('TUXOPAY_ORCHESTRATOR_VERSION', '1.0.0');
define('TUXOPAY_ORCHESTRATOR_PLUGIN_FILE', __FILE__);
define('TUXOPAY_ORCHESTRATOR_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('TUXOPAY_ORCHESTRATOR_PLUGIN_URL', plugin_dir_url(__FILE__));

// Declare HPOS compatibility
add_action('before_woocommerce_init', function() {
    if (class_exists(\Automattic\WooCommerce\Utilities\FeaturesUtil::class)) {
        \Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility('custom_order_tables', __FILE__, true);
    }
});

// Load the gateway class
add_action('plugins_loaded', 'tuxopay_orchestrator_init', 11);

function tuxopay_orchestrator_init() {
    if (!class_exists('WC_Payment_Gateway')) {
        return;
    }

    require_once TUXOPAY_ORCHESTRATOR_PLUGIN_DIR . 'includes/class-wc-gateway-tuxopay.php';
    require_once TUXOPAY_ORCHESTRATOR_PLUGIN_DIR . 'includes/class-tuxopay-webhook-handler.php';

    // Register the gateway
    add_filter('woocommerce_payment_gateways', 'tuxopay_orchestrator_add_gateway');

    // Register webhook handler
    add_action('woocommerce_api_tuxopay_webhook', array('TuxoPay_Webhook_Handler', 'handle'));
}

function tuxopay_orchestrator_add_gateway($gateways) {
    $gateways[] = 'WC_Gateway_TuxoPay';
    return $gateways;
}

// Register block support
add_action('woocommerce_blocks_loaded', 'tuxopay_orchestrator_register_blocks_support');

function tuxopay_orchestrator_register_blocks_support() {
    if (!class_exists('Automattic\WooCommerce\Blocks\Payments\Integrations\AbstractPaymentMethodType')) {
        return;
    }

    require_once TUXOPAY_ORCHESTRATOR_PLUGIN_DIR . 'includes/class-wc-gateway-tuxopay-blocks-support.php';

    add_action(
        'woocommerce_blocks_payment_method_type_registration',
        function(Automattic\WooCommerce\Blocks\Payments\PaymentMethodRegistry $payment_method_registry) {
            $payment_method_registry->register(new WC_Gateway_TuxoPay_Blocks_Support());
        }
    );
}
